/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.db.model;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import jgamebase.Const;
import jgamebase.db.Db;
import jgamebase.db.model.Game;
import jgamebase.db.model.Music;
import jgamebase.model.Emulators;
import jgamebase.model.Paths;
import jgamebase.model.Plugins;
import jgamebase.plugins.Extractor;
import jgamebase.tools.DownloadTools;
import jgamebase.tools.FileTools;
import jgamebase.tools.SystemTools;
import jgamebase.tools.TempDir;

public class Extra {
    private static final long serialVersionUID = -1550316222014503342L;
    private static final List<Category> categories = new ArrayList<Category>();
    private static List<Extra> deletionQueue = new ArrayList<Extra>();
    private int id;
    private int gameId = -1;
    private int displayOrder;
    private int type;
    private String name;
    private String filename;
    private boolean enabled;
    private String data;
    private String fileToRun;
    private Category category = null;

    public Extra() {
    }

    public Extra(int id) {
        this.id = id;
    }

    public static void enqueueForDeletion(Extra extra) {
        deletionQueue.add(extra);
    }

    public static void processQueuedForDeletion() {
        if (deletionQueue.size() > 0) {
            Db.deleteAll(deletionQueue);
        }
        deletionQueue = new ArrayList<Extra>();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getGameId() {
        return this.gameId;
    }

    public void setGameId(int gameId) {
        this.gameId = gameId;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFilename() {
        if (Extra.checkFilenameIsUrl(this.filename)) {
            return this.filename == null ? "" : this.filename;
        }
        return Paths.backslashToSlash(this.filename);
    }

    public void setFilename(String filename) {
        this.filename = Extra.checkFilenameIsUrl(filename) ? filename : Paths.slashToBackslash(filename);
    }

    private static boolean checkFilenameIsUrl(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        String t = s.toLowerCase();
        return t.startsWith("http:") || t.startsWith("https:") || t.startsWith("ftp:");
    }

    public boolean isUrl() {
        return Extra.checkFilenameIsUrl(this.filename);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getData() {
        return this.data == null ? "" : this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getFileToRun() {
        return this.fileToRun == null ? "" : this.fileToRun;
    }

    public void setFileToRun(String fileToRun) {
        this.fileToRun = fileToRun;
    }

    public boolean isAdditional() {
        return this.getFilename().startsWith("Additional");
    }

    public void reevaluateCategory() {
        this.category = null;
        this.getCategory();
    }

    public Category getCategory() {
        if (this.category != null) {
            return this.category;
        }
        if (!this.isUrl()) {
            this.category = Extra.findCategoryByPath(this.getFilename());
        }
        if (this.category != null) {
            return this.category;
        }
        this.category = Extra.findCategoryByName(this.getName(), this.isUrl());
        if (this.category != null) {
            return this.category;
        }
        this.category = Category.Misc;
        return this.category;
    }

    private static Category findCategoryByPath(String filename) {
        Category category = null;
        StringTokenizer st = new StringTokenizer(filename, "/");
        block0: while (st.hasMoreTokens()) {
            String pathPart = st.nextToken();
            for (Category possibleCategory : categories) {
                if (category != null || !possibleCategory.startsWith(pathPart)) continue;
                category = possibleCategory;
                continue block0;
            }
        }
        return category;
    }

    private static Category findCategoryByName(String name, boolean isUrl) {
        Category category = null;
        if (!isUrl) {
            for (Category possibleCategory : categories) {
                if (category != null || !possibleCategory.startsWith(name)) continue;
                category = possibleCategory;
                return category;
            }
        }
        StringTokenizer st = new StringTokenizer(name, " ,.;:-_/@|{}\\[]()");
        ArrayList<String> partList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            partList.add(st.nextToken());
        }
        String[] parts = partList.toArray(new String[0]);
        if (isUrl) {
            int i = parts.length - 1;
            while (i > 0) {
                for (Category possibleCategory : categories) {
                    if (!possibleCategory.startsWith(parts[i])) continue;
                    category = possibleCategory;
                    return category;
                }
                --i;
            }
        } else {
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                for (Category possibleCategory : categories) {
                    if (!possibleCategory.startsWith(part)) continue;
                    category = possibleCategory;
                    return category;
                }
                ++n2;
            }
        }
        return category;
    }

    public boolean isAnimation() {
        String extension = FileTools.getExtension(this.getFilename());
        return "gif".equalsIgnoreCase(extension) && this.getCategory() == Category.GameImage;
    }

    public boolean isImage() {
        String extension = FileTools.getExtension(this.getFilename());
        return !this.isAnimation() && ("jpg".equalsIgnoreCase(extension) || "png".equalsIgnoreCase(extension) || "gif".equalsIgnoreCase(extension) || "bmp".equalsIgnoreCase(extension));
    }

    public String toString() {
        return this.getName();
    }

    public void play() throws IOException {
        try {
            if (this.isUrl()) {
                Const.log.info((Object)("Open extra as URL='" + new URI(this.filename) + "'."));
                SystemTools.open(new URI(this.filename));
            } else {
                Extra.play(this);
            }
        }
        catch (URISyntaxException e) {
            Const.log.warn((Object)("Could not open extra '" + this.getName() + "' as URL '" + this.filename + "'."), (Throwable)e);
        }
    }

    private static void play(Extra extra) throws IOException {
        File extraFile = Paths.getExtraPath().findAndWarn(new File(extra.getFilename()));
        if (extraFile == null) {
            return;
        }
        String filename = extraFile.toString();
        List<String> filenames = null;
        Const.log.info((Object)("Trying to open extra " + filename));
        if (Plugins.existsExtractorForExtension(FileTools.getExtension(filename))) {
            Const.log.info((Object)"extracting to temp");
            Extractor extractor = Plugins.getExtractorForExtension(FileTools.getExtension(filename));
            try {
                TempDir.cleanPath();
                TempDir.getPath();
                filenames = extractor.extractToDir(filename, TempDir.getPath().getCanonicalPath());
                if (filenames == null || filenames.size() == 0) {
                    return;
                }
                filename = filenames.get(0);
                Const.log.info((Object)("now Trying to open " + filename));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (filenames != null && filenames.size() > 1 && new File(filename).getParent() != null) {
            SystemTools.open(new File(filename).getParentFile().toURI());
        }
        if (Emulators.findGameEmulatorForExtension(FileTools.getExtension(filename)) != null) {
            Const.log.info((Object)("Opening extra '" + filename + "' as game: found emulator '" + Emulators.findGameEmulatorForExtension(FileTools.getExtension(filename)).getName() + "' for extension '" + FileTools.getExtension(filename) + "'."));
            Game srcGame = Db.getGameById(extra.getGameId());
            Game game = new Game();
            game.setKeyValuePairs(srcGame.getKeyValuePairs());
            game.setFileToRun(filename);
            game.play(true);
            return;
        }
        if (Emulators.findMusicEmulatorForExtension(FileTools.getExtension(filename)) != null) {
            Const.log.info((Object)("Opening extra '" + filename + "' as music: found emulator '" + Emulators.findMusicEmulatorForExtension(FileTools.getExtension(filename)).getName() + "' for extension '" + FileTools.getExtension(filename) + "'."));
            Music music = new Music();
            music.setFilename(filename);
            music.play();
            return;
        }
        try {
            File file = new File(filename);
            URI uri = new URI(file.toURI().getScheme(), "", file.toURI().getPath(), null);
            Const.log.info((Object)("Opening extra '" + filename + "' via OS:'" + uri + "'."));
            SystemTools.open(uri);
        }
        catch (URISyntaxException uRISyntaxException) {}
    }

    public void download() {
        try {
            if (this.isUrl()) {
                Const.log.info((Object)("Download extra from URL='" + new URI(this.filename) + "'."));
                Extra.download(this);
            } else {
                Const.log.warn((Object)"Can't download: Extra is nor URL.");
            }
        }
        catch (URISyntaxException e) {
            Const.log.warn((Object)("Could not open extra '" + this.getName() + "' as URL '" + this.filename + "'."), (Throwable)e);
        }
    }

    private static void download(Extra extra) {
        try {
            File targetDir = new File(Paths.getAdditionalExtraPathId(extra.getGameId()), extra.getCategory().getDir());
            DownloadTools.downloadUriToFile(new URI(extra.getFilename()), targetDir);
        }
        catch (URISyntaxException e) {
            Const.log.warn((Object)("Could not open extra '" + extra.getName() + "' as URL '" + extra.getFilename() + "'."), (Throwable)e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Extra)) {
            return false;
        }
        Extra e = (Extra)obj;
        return this.getId() == e.getId() && this.getGameId() == e.getGameId() && this.getDisplayOrder() == e.getDisplayOrder() && this.getType() == e.getType() && this.getName().equals(e.getName()) && this.getFilename().equals(e.getFilename()) && this.isUrl() == e.isUrl() && this.getData().equals(e.getData()) && this.getFileToRun().equals(e.getFileToRun()) && this.getCategory() == e.getCategory();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getId();
        result = 37 * result + this.getGameId();
        result = 37 * result + this.getDisplayOrder();
        result = 37 * result + this.getType();
        result = 37 * result + this.getName().hashCode();
        result = 37 * result + this.getFilename().hashCode();
        result = 37 * result + (this.isUrl() ? 0 : 1);
        result = 37 * result + this.getData().hashCode();
        result = 37 * result + this.getFileToRun().hashCode();
        result = 37 * result + this.getCategory().hashCode();
        return result;
    }

    public static enum Category {
        GameImage(Const.ICON_CATEGORY_GAMEIMAGE, new String[]{"animations", "animation", "screenshot", "screenshot"}, "Animation"),
        AdditionalImage(Const.ICON_CATEGORY_ADDITIONALIMAGE, new String[0], "Animation"),
        AdditionalImage_Advertisement(Const.ICON_CATEGORY_ADDITIONALIMAGE_ADVERTISEMENT, new String[]{"adverts", "advert"}, "Covers"),
        AdditionalImage_Bookcover(Const.ICON_CATEGORY_ADDITIONALIMAGE_BOOKCOVER, new String[]{"books", "book", "magcovers", "magcover"}, "Covers"),
        Documentation(Const.ICON_CATEGORY_DOCUMENTATION, new String[]{"documentation", "docs", "doc", "instructions", "instruction"}, "Manuals"),
        Documentation_Manual(Const.ICON_CATEGORY_DOCUMENTATION_MANUAL, new String[]{"manuals", "manual"}, "Manuals"),
        Solution(Const.ICON_CATEGORY_SOLUTION, new String[]{"hints, tips, cheats & walkthroughs", "cheats", "cheat", "solutions", "solution"}, "Solutions"),
        Solution_Map(Const.ICON_CATEGORY_SOLUTION_MAP, new String[]{"maps", "map"}, "Solutions"),
        Solution_Tip(Const.ICON_CATEGORY_SOLUTION_TIP, new String[]{"hints & tips", "hint", "tips", "tip", "tipps", "tipp"}, "Solutions"),
        Solution_walkthrough(Const.ICON_CATEGORY_SOLUTION_WALKTHROUGH, new String[]{"walkthrough"}, "Solutions"),
        Review(Const.ICON_CATEGORY_REVIEW, new String[]{"gazette!", "magazine", "reviews", "review"}, "Reviews"),
        Movie(Const.ICON_CATEGORY_MOVIE, new String[]{"longplays", "longplay", "movies", "movie"}, "Longplays"),
        Media(Const.ICON_CATEGORY_MEDIA, new String[]{"media", "sps", "listings", "listing"}, "Media"),
        Media_Cartridge(Const.ICON_CATEGORY_MEDIA_CARTRIDGE, new String[]{"cartridges", "cartridge", "carts", "cart", "crt"}, "Media"),
        Media_Tape(Const.ICON_CATEGORY_MEDIA_TAPE, new String[]{"covertapes", "covertape", "tapes", "tape", "tap"}, "Media"),
        Media_Disk(Const.ICON_CATEGORY_MEDIA_DISK, new String[]{"coverdisks", "coverdisk", "disks", "disk"}, "Media"),
        AdditionalImage_Cover(Const.ICON_CATEGORY_ADDITIONALIMAGE_COVER, new String[]{"boxscans", "boxscan", "covers", "cover"}, "Covers"),
        Media_Harddisk(Const.ICON_CATEGORY_MEDIA_HARDDISK, new String[]{"harddisks", "harddisk", "whdload"}, "Media"),
        Misc(Const.ICON_CATEGORY_MISC, new String[]{"misc", "missing", "other", "mp3s", "mp3"}, "Misc");

        private final Icon icon;
        private final String[] matches;
        private final String dir;

        private Category(Icon icon, String[] matches, String dir) {
            this.icon = icon;
            this.matches = matches;
            this.dir = dir;
            categories.add(this);
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getDir() {
            return this.dir;
        }

        public boolean startsWith(String potentialMatch) {
            String[] stringArray = this.matches;
            int n = this.matches.length;
            int n2 = 0;
            while (n2 < n) {
                String matche = stringArray[n2];
                if (potentialMatch.toLowerCase().startsWith(matche.toLowerCase())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public boolean contains(String potentialMatch) {
            String[] stringArray = this.matches;
            int n = this.matches.length;
            int n2 = 0;
            while (n2 < n) {
                String matche = stringArray[n2];
                if (potentialMatch.toLowerCase().contains(matche.toLowerCase())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

